<?php
$api_key = 'ec8237f367023fbadd38ab6a1596b40c';
$url = "https://api.themoviedb.org/3/trending/movie/week?api_key=$api_key&language=pt-BR";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);
$movies = array_slice($data['results'], 0, 5);

// Buscar detalhes extras (runtime e genres) de cada filme
foreach ($movies as $key => $movie) {
    $movie_id = $movie['id'];
    $details_url = "https://api.themoviedb.org/3/movie/$movie_id?api_key=$api_key&language=pt-BR";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $details_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $details_response = curl_exec($ch);
    curl_close($ch);

    $details = json_decode($details_response, true);
    $movies[$key]['runtime'] = $details['runtime'] ?? 90;
    $movies[$key]['genres'] = array_column($details['genres'] ?? [], 'name');
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <title>Trending TMDB</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    body {
      font-family: Arial, sans-serif;
      background: black;
      color: white;
      overflow: hidden;
      height: 100vh;
    }
    main {
      position: relative;
      width: 100%;
      height: 100vh;
      overflow: hidden;
    }
    .movie-section {
      position: absolute;
      top: 0; left: 0;
      width: 100vw;
      height: 100vh;
      background-size: 100% 100%;
      background-position: center;
      opacity: 0;
      transition: opacity 1s ease-in-out;
      z-index: 0;
    }
    .movie-section.active {
      opacity: 1;
      z-index: 1;
    }
    .overlay {
      background: rgba(0, 0, 0, 0.6);
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 40px;
      width: 100%;
      height: 100%;
    }
    .content {
      max-width: 600px;
    }
    h1 {
      font-size: 38px;
      margin-bottom: 10px;
    }
    .meta {
      font-size: 8px;
      margin-bottom: 10px;
    }
    .stars {
      color: gold;
    }
    .tags span {
      background: rgba(255, 255, 255, 0.2);
      padding: 5px 10px;
      border-radius: 10px;
      margin-right: 5px;
    }
    .description {
      margin-top: 15px;
      line-height: 1.6;
    }
    .poster {
      margin-left: 50px;
      transform: rotateY(-12deg);
      transition: transform 0.5s ease;
      perspective: 1000px;
      transform-style: preserve-3d;
    }
    .poster img {
      border-radius: 10px;
      box-shadow: 0 0 15px rgba(0,0,0,0.6);
      max-height: 320px;
    }
    .poster:hover {
      transform: rotateY(0deg) scale(1.05);
    }
  </style>
</head>
<body>
<main>
  <?php foreach ($movies as $index => $movie): 
    $title = $movie['title'];
    $year = substr($movie['release_date'] ?? '', 0, 4);
    $runtime = $movie['runtime'] ?? 90;
    $rating = number_format($movie['vote_average'], 1);
    $overview = mb_strimwidth($movie['overview'], 0, 200, '...');
    $genres = $movie['genres'];
    $background = 'https://image.tmdb.org/t/p/w780' . $movie['backdrop_path'];
    $poster = 'https://image.tmdb.org/t/p/w500' . $movie['poster_path'];
  ?>
  <section class="movie-section<?= $index === 0 ? ' active' : '' ?>" style="background-image: url('<?= $background ?>')">
    <div class="overlay">
      <div class="content">
        <h1><?= htmlspecialchars($title) ?></h1>
        <div class="meta"><?= $year ?> • <?= $runtime ?> min • <span class="stars">★ <?= $rating ?></span></div>
        <div class="tags">
          <?php foreach($genres as $tag): ?>
            <span><?= htmlspecialchars($tag) ?></span>
          <?php endforeach; ?>
        </div>
        <div class="description"><?= htmlspecialchars($overview) ?></div>
      </div>
      <div class="poster">
        <img src="<?= $poster ?>" alt="Poster">
      </div>
    </div>
  </section>
  <?php endforeach; ?>
</main>

<script>
  document.addEventListener("DOMContentLoaded", () => {
    const sections = document.querySelectorAll(".movie-section");
    let index = 0;

    setInterval(() => {
      sections[index].classList.remove("active");
      index = (index + 1) % sections.length;
      sections[index].classList.add("active");
    }, 10000); // Troca a cada 10 segundos
  });
</script>
</body>
</html>