<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include(__DIR__ . '/includes/functions.php');
$static_url = dirname($_SERVER['SCRIPT_NAME']) . '/assets/';
include 'session_check.php';

// Configurações do arquivo JSON 🏆
$arquivo_json = __DIR__ . '/sport.json';
$dados_json = [];

// Carrega dados existentes do arquivo JSON 📤
if (file_exists($arquivo_json)) {
    $conteudo_json = file_get_contents($arquivo_json);
    $dados_json = json_decode($conteudo_json, true);
}

// URL atual ⚽
$url_atual = $dados_json['url'] ?? '';

// Processamento do formulário 📝
$success_message = "";
$error_message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST["nova_url"])) {
        $nova_url = trim($_POST["nova_url"]);
        
        // Validação da URL 🔍
        if (!filter_var($nova_url, FILTER_VALIDATE_URL)) {
            $error_message = "⚠️ Por favor, insira uma URL válida!";
        } else {
            // Atualiza os dados 🏅
            $dados_json = ["url" => $nova_url];
            
            // Salva no arquivo JSON 💾
            if (file_put_contents($arquivo_json, json_encode($dados_json, JSON_PRETTY_PRINT))) {
                $url_atual = $nova_url;
                $success_message = "✅ URL esportiva atualizada com sucesso! ⚽";
            } else {
                $error_message = "❌ Falha ao salvar a URL. Verifique as permissões do arquivo.";
            }
        }
    }
}

$page_title = "⚽ Gerenciamento de Esportes";

$page_content = '<div class="container mt-5">
    <div class="card mb-5 mb-xl-12">
        <div class="card-body py-12">
            <div class="d-flex align-items-center mb-7">
                <span class="symbol symbol-50px me-5">
                    <span class="symbol-label bg-light-primary">
                        <i class="ki-outline ki-sports fs-2x text-primary"></i>
                    </span>
                </span>
                <h2 class="mb-0">🏆 Gerenciamento de Transmissão Esportiva</h2>
            </div>';

if (!empty($success_message)) {
    $page_content .= '<div class="alert alert-success d-flex align-items-center" role="alert">
        <i class="ki-outline ki-check-circle fs-2x text-success me-4"></i>
        <div class="d-flex flex-column">
            <h4 class="mb-1 text-success">Sucesso!</h4>
            <span>' . htmlspecialchars($success_message) . '</span>
        </div>
    </div>';
}

if (!empty($error_message)) {
    $page_content .= '<div class="alert alert-danger d-flex align-items-center" role="alert">
        <i class="ki-outline ki-cross-circle fs-2x text-danger me-4"></i>
        <div class="d-flex flex-column">
            <h4 class="mb-1 text-danger">Erro!</h4>
            <span>' . htmlspecialchars($error_message) . '</span>
        </div>
    </div>';
}

$page_content .= '<div class="row mb-12">
                <div class="col-xl-12 mb-15 mb-xl-0 pe-5">
                    <h4 class="mb-4">🔧 Configuração do Link Esportivo</h4>
                    <p class="fs-6 fw-semibold text-gray-600 py-4 m-0">
                        🎯 Atualize o link de transmissão esportiva abaixo. Certifique-se de usar uma URL válida.
                    </p>
                    
                    <form method="POST" action="">
                        <div class="form-group mb-6">
                            <label for="nova_url" class="fs-5 fw-bold mb-3">🌍 Nova URL de Transmissão:</label>
                            <input 
                                type="url" 
                                class="form-control form-control-lg" 
                                name="nova_url" 
                                id="nova_url" 
                                placeholder="https://exemplo.com/transmissao" 
                                value="' . htmlspecialchars($url_atual) . '"
                                required>
                            <div class="text-muted mt-2">🔗 Deve começar com http:// ou https://</div>
                        </div>
                        
                        <div class="d-flex justify-content-between mt-8">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="ki-outline ki-check fs-2 me-2"></i> 🚀 Salvar Configurações
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <div class="row mt-10">
                <div class="col-xl-12">
                    <div class="notice d-flex bg-light-success rounded border-success border border-dashed p-6">
                        <span class="svg-icon svg-icon-2tx svg-icon-success me-4">
                            <i class="ki-outline ki-information fs-2x text-success"></i>
                        </span>
                        <div class="d-flex flex-stack flex-grow-1">
                            <div class="fw-semibold">
                                <h4 class="text-gray-900 fw-bold">📌 URL Atual Configurada</h4>
                                <div class="fs-5 text-gray-700">
                                    ' . (!empty($url_atual) ? 
                                        '<a href="' . htmlspecialchars($url_atual) . '" target="_blank" class="text-primary fw-bold">' . 
                                        htmlspecialchars($url_atual) . '</a>' : 
                                        '⛔ Nenhuma URL configurada') . '
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="separator separator-dashed my-10"></div>
            
            <div class="row g-5">
                <div class="col-xl-4">
                    <div class="d-flex align-items-center bg-light-warning rounded p-5">
                        <i class="ki-outline ki-football fs-2x text-warning me-5"></i>
                        <div class="flex-grow-1 me-2">
                            <h5 class="text-warning fw-bold mb-1">Futebol</h5>
                            <div class="text-gray-700 fw-semibold">⚽ Transmissão ao vivo</div>
                        </div>
                    </div>
                </div>
                
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>';

include 'includes/layout.php';
?>