<?php include './includes/header.php'; ?>

<?php
$jsonFile = 'img/api.json';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $opcao = $_POST['opcao'];

    $novoValor = ($opcao === 'automatico') 
        ? "https://launcher.storeart.top/teste/api/webview.php" 
        : "https://launcher.storeart.top/teste/img/fundo_max.png";

    $dados = json_decode(file_get_contents($jsonFile), true);
    $dados['background'] = $novoValor;

    file_put_contents($jsonFile, json_encode($dados, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
    echo "<script>alert('Atualizado com sucesso!'); window.location.href='editar_json.php';</script>";
    exit;
}

$dadosAtuais = json_decode(file_get_contents($jsonFile), true);
$backgroundAtual = $dadosAtuais['background'];
?>

<!-- Font Awesome para ícones -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
    .container {
        max-width: 500px;
        margin: 40px auto;
        background: #f9f9f9;
        border-radius: 12px;
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
        padding: 30px;
        font-family: Arial, sans-serif;
    }
    h2 {
        text-align: center;
        margin-bottom: 10px;
    }
    .description {
        text-align: center;
        margin-bottom: 25px;
        color: #555;
    }
    label {
        display: block;
        padding: 10px;
        font-size: 16px;
    }
    button {
        background-color: #28a745;
        color: white;
        border: none;
        padding: 12px 20px;
        font-size: 16px;
        border-radius: 6px;
        cursor: pointer;
        width: 100%;
    }
    button:hover {
        background-color: #218838;
    }
    .icon {
        margin-right: 8px;
        color: #007bff;
    }
</style>

<div class="container">
    <h2><i class="fas fa-image icon"></i> Alterar Tipo de Fundo</h2>
    <p class="description">
        Escolha entre exibir <strong>anúncios manuais</strong> (imagem estática) ou <strong>filmes automáticos</strong> (conteúdo dinâmico).<br>
        Esta configuração será aplicada automaticamente no fundo do sistema.
    </p>

    <form method="post">
        <label>
            <input type="radio" name="opcao" value="automatico" <?= ($backgroundAtual === "https://launcher.storeart.top/teste/api/webview.php") ? 'checked' : '' ?>>
            <i class="fas fa-film icon"></i> Filmes Automáticos
        </label>

        <label>
            <input type="radio" name="opcao" value="manual" <?= ($backgroundAtual === "https://launcher.storeart.top/teste/img/fundo_max.png") ? 'checked' : '' ?>>
            <i class="fas fa-bullhorn icon"></i> Anúncios Manuais
        </label><br>

        <button type="submit"><i class="fas fa-save"></i> Salvar Alteração</button>
    </form>
</div>

<?php include './includes/footer.php'; ?>
