<?php

require_once("qrlib.php");

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Verifique se foi enviada uma URL
    if (isset($_POST["url"])) {
        // Obtenha a URL do formulário
        $url = "https://".$_POST["url"];
        
        // Crie o QR code
        $qr = QRCode::getMinimumQRCode($url, QR_ERROR_CORRECT_LEVEL_L);
        
        // Crie a imagem do QR code
        $im = $qr->createImage(6, 8);
        
        // Caminho para salvar o arquivo
        $filepath = "api/qr/qr.png";
        
        // Salve a imagem no arquivo
        imagepng($im, $filepath);
        
        // Libere a memória
        imagedestroy($im);
        
        // Exiba o QR code na página
        header("Location: qrcode.php");
    } else {
        echo "Por favor, insira um número.";
    }
} else {
    // Redirecione para a página inicial se o formulário não foi enviado
    header("Location: qrcode.php");
    exit;
}

?>