<?php 
include './includes/header.php';

// Leitura do arquivo JSON
$jsonData = file_get_contents('img/api.json');
$jsonArray = json_decode($jsonData, true);

// Extrair as URLs das imagens
$imageUrls = [];
for ($i = 1; $i <= 10; $i++) {
    $imageUrls[] = $jsonArray['data'][0]["url" . $i]; // Adiciona as URLs url1 até url10
}

if (isset($_POST["submit"])) {
    unset($_POST["submit"]);
    $updateData = $_POST;
    $db->update($table_name, $updateData, "id = :id", [":id" => 1]);
    echo "<script>alert('Sucesso!');window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=1'</script>";
}

// Função para atualizar o JSON com a nova imagem
function updateJson($imageIndex, $imagePath) {
    $jsonData = file_get_contents('img/api.json');
    $jsonArray = json_decode($jsonData, true);

    $domain = "https://" . $_SERVER['HTTP_HOST']; // Obtém o domínio atual

    // Remover qualquer ocorrência de "lolimg" no caminho, caso exista
    $imagePath = str_replace('/uploads/', '/', $imagePath);

    // Atualiza o URL da imagem no JSON
    $jsonArray['data'][0]["url" . $imageIndex] = $domain . $imagePath;

    // Salva o JSON atualizado
    file_put_contents('img/api.json', json_encode($jsonArray, JSON_PRETTY_PRINT));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['image'])) {
    $imageIndex = $_POST['image_index'];
    $uploadedFile = $_FILES['image'];

    // Diretório de upload
    $uploadDir = '/img/';  // Salva diretamente em 'img/'
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    // O caminho correto para salvar a imagem
    $filePath = $uploadDir . basename($uploadedFile['name']);
    if (move_uploaded_file($uploadedFile['tmp_name'], $_SERVER['DOCUMENT_ROOT'] . '/' . $filePath)) {
        // Atualiza o JSON com o novo URL da imagem
        updateJson($imageIndex, $filePath);
        echo "<script>alert('Imagem atualizada com sucesso!');window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=1'</script>";
    } else {
        echo "<script>alert('Falha ao enviar a imagem.');</script>";
    }
}
?>

<style>
    .image-container {
        background-color: #003366; /* Azul escuro */
        padding: 10px;
        border-radius: 5px;
        text-align: center;
    }

    .image-container img {
        width: 30px;  /* Largura de 30px */
        height: 30px; /* Altura de 30px */
        object-fit: cover; /* Garantir que a imagem mantenha o aspecto mesmo com o corte */
    }
</style>


        </form>

        <!-- Exibir as imagens -->
        <div class="mt-4">
            <h5>Imagens Exibidas:</h5>
            <div class="row">
                <?php foreach ($imageUrls as $index => $imageUrl): ?>
                    <div class="col-md-4 mb-3">
                        <!-- Exibe a imagem em cima do botão dentro de um fundo azul escuro -->
                        <div class="image-container">
                            <img src="<?php echo $imageUrl; ?>" alt="Imagem" class="img-fluid mb-2" />
                        </div>

                        <!-- Formulário para alterar a imagem -->
                        <form method="post" enctype="multipart/form-data">
                            <input type="hidden" name="image_index" value="<?php echo $index + 1; ?>">
                            <!-- Campo de upload da imagem -->
                            <input type="file" name="image" accept="image/*" class="form-control-file">
                            <button type="submit" class="btn btn-sm btn-warning mt-2 w-100">Alterar Imagem</button>
                        </form>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

<?php include './includes/footer.php'; ?>
