<?php
// painel.php

if (isset($_GET['sucesso'])) {
    $message = "Aplicativo salvo com sucesso!";
}
?>
<?php include './includes/header.php'; ?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Painel MaxLauncher</title>
    <!-- Ícones do Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f0f2f5;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        h1 {
            color: #4A90E2;
            text-align: center;
            margin-top: 30px;
        }
        form {
            background: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            max-width: 500px;
            margin: 30px auto;
        }
        .form-group {
            margin-bottom: 20px;
            position: relative;
        }
        .form-group input[type="text"],
        .form-group input[type="file"] {
            width: 100%;
            padding: 12px 40px 12px 12px;
            border: 1px solid #ccc;
            border-radius: 8px;
            transition: border-color 0.3s;
        }
        .form-group input:focus {
            border-color: #4A90E2;
            outline: none;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: 600;
        }
        .form-group i {
            position: absolute;
            right: 15px;
            top: 40px;
            color: #aaa;
        }
        button {
            width: 100%;
            padding: 12px;
            background-color: #4A90E2;
            color: #fff;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        button:hover {
            background-color: #357ABD;
        }
        .message {
            margin: 20px auto;
            max-width: 500px;
            background-color: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 8px;
            text-align: center;
            font-weight: bold;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .progress-container {
            width: 100%;
            background-color: #eee;
            border-radius: 8px;
            margin-top: 10px;
            position: relative;
            height: 25px;
            display: none;
        }
        .progress-bar {
            width: 0%;
            height: 100%;
            background-color: #4A90E2;
            border-radius: 8px;
            transition: width 0.3s;
        }
        #progress-text {
            position: absolute;
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            font-weight: bold;
            color: #333;
            line-height: 25px;
        }
        .status-log {
            margin-top: 15px;
            padding: 10px;
            border-radius: 5px;
            background-color: #f8f9fa;
            border: 1px solid #ddd;
            max-height: 200px;
            overflow-y: auto;
            display: none;
        }
        .status-log p {
            margin: 5px 0;
            padding: 3px 0;
            border-bottom: 1px solid #eee;
            color: #333;
            font-size: 14px;
        }
        .status-log p.success {
            color: #28a745;
        }
        .status-log p.error {
            color: #dc3545;
        }
        .status-log p.info {
            color: #17a2b8;
        }
        @media (max-width: 600px) {
            form {
                padding: 20px;
                margin: 20px;
            }
            .message {
                margin: 20px;
            }
        }
    </style>
</head>
<body>

<h1><i class="fas fa-plus-circle"></i> Painel - Adicionar Aplicativo</h1>

<?php if (isset($message)) { echo "<div class='message'><i class='fas fa-check-circle'></i> {$message}</div>"; } ?>

<form method="POST" action="salvar_apps.php" enctype="multipart/form-data">
    <div class="form-group">
        <label>Nome do Aplicativo</label>
        <input type="text" name="name" placeholder="Ex: Youtube" required>
        <i class="fas fa-font"></i>
    </div>

    <div class="form-group">
        <label>Nome do Pacote (package)</label>
        <input type="text" name="package" placeholder="Ex: com.storeart.xyz" required>
        <i class="fas fa-box"></i>
    </div>

    <div class="form-group">
        <label>Ícone do App (.png, .jpg)</label>
        <input type="file" name="icon_file" accept="image/*" required>
        <i class="fas fa-image"></i>
    </div>

    <div class="form-group">
        <label>Arquivo APK (.apk)</label>
        <input type="file" name="apk_file" accept=".apk" required>
        <i class="fas fa-file-archive"></i>
        
        <!-- Barra de Progresso -->
        <div class="progress-container" id="progress-container">
            <div class="progress-bar" id="progress-bar"></div>
            <span id="progress-text">0%</span>
        </div>
        
        <!-- Área de status/log -->
        <div class="status-log" id="status-log"></div>
    </div>

    <button type="submit"><i class="fas fa-save"></i> Salvar Aplicativo</button>
</form>

<?php include './includes/footer.php'; ?>

<!-- Script da barra de progresso e status -->
<script>
document.querySelector('form').addEventListener('submit', function(e) {
    e.preventDefault();

    const form = e.target;
    const formData = new FormData(form);
    const xhr = new XMLHttpRequest();

    const progressBar = document.getElementById('progress-bar');
    const progressText = document.getElementById('progress-text');
    const progressContainer = document.getElementById('progress-container');
    const statusLog = document.getElementById('status-log');
    const button = form.querySelector('button');

    // Exibe a barra e o log
    progressContainer.style.display = 'block';
    statusLog.style.display = 'block';
    progressBar.style.width = '0%';
    progressText.textContent = '0%';
    statusLog.innerHTML = '<p class="info">Preparando para enviar arquivos...</p>';

    // Desabilita o botão
    button.disabled = true;
    button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Enviando...';

    // Adiciona logs de verificação dos arquivos
    const iconFile = form.querySelector('input[name="icon_file"]').files[0];
    const apkFile = form.querySelector('input[name="apk_file"]').files[0];
    
    statusLog.innerHTML += `<p class="info">Verificando arquivos...</p>`;
    statusLog.innerHTML += `<p class="info">Ícone: ${iconFile ? iconFile.name + ' (' + (iconFile.size/1024).toFixed(2) + ' KB)' : 'Nenhum arquivo selecionado'}</p>`;
    statusLog.innerHTML += `<p class="info">APK: ${apkFile ? apkFile.name + ' (' + (apkFile.size/1024/1024).toFixed(2) + ' MB)' : 'Nenhum arquivo selecionado'}</p>`;
    
    // Rolagem automática para o final do log
    statusLog.scrollTop = statusLog.scrollHeight;

    xhr.upload.addEventListener('progress', function(e) {
        if (e.lengthComputable) {
            const percent = Math.round((e.loaded / e.total) * 100);
            progressBar.style.width = percent + '%';
            progressText.textContent = percent + '%';
            
            // Atualiza o log com o progresso
            if (percent % 10 === 0 || percent === 100) {
                const existingLogs = statusLog.querySelectorAll('p');
                const lastLog = existingLogs[existingLogs.length - 1];
                
                if (!lastLog.textContent.includes(`Enviado: ${percent}%`)) {
                    statusLog.innerHTML += `<p class="info">Enviado: ${percent}%</p>`;
                    statusLog.scrollTop = statusLog.scrollHeight;
                }
            }
        }
    });

    xhr.onreadystatechange = function() {
        if (xhr.readyState === 4) {
            button.disabled = false;
            button.innerHTML = '<i class="fas fa-save"></i> Salvar Aplicativo';

            if (xhr.status === 200) {
                statusLog.innerHTML += `<p class="success">Upload finalizado com sucesso!</p>`;
                statusLog.innerHTML += `<p class="info">Processando arquivos no servidor...</p>`;
                statusLog.scrollTop = statusLog.scrollHeight;
                
                // Simula processamento no servidor (você pode remover isso se o servidor já enviar atualizações)
                setTimeout(() => {
                    statusLog.innerHTML += `<p class="success">Ícone movido para a pasta de destino</p>`;
                    statusLog.scrollTop = statusLog.scrollHeight;
                    
                    setTimeout(() => {
                        statusLog.innerHTML += `<p class="success">APK movido para a pasta de destino</p>`;
                        statusLog.scrollTop = statusLog.scrollHeight;
                        
                        setTimeout(() => {
                            statusLog.innerHTML += `<p class="success">Informações do aplicativo salvas no banco de dados</p>`;
                            statusLog.scrollTop = statusLog.scrollHeight;
                            
                            // Redireciona após mostrar todos os status
                            setTimeout(() => {
                                window.location.href = 'painel.php?sucesso=1';
                            }, 1000);
                        }, 800);
                    }, 800);
                }, 800);
            } else {
                statusLog.innerHTML += `<p class="error">Erro ao enviar: ${xhr.statusText}</p>`;
                statusLog.scrollTop = statusLog.scrollHeight;
                alert('Erro ao enviar. Verifique os dados e tente novamente.');
            }
        } else if (xhr.readyState === 3) {
            // Estado LOADING (Dados estão sendo recebidos)
            statusLog.innerHTML += `<p class="info">Servidor está processando os arquivos...</p>`;
            statusLog.scrollTop = statusLog.scrollHeight;
        }
    };

    xhr.open('POST', form.action, true);
    
    // Adiciona um evento para quando o envio começar
    xhr.upload.addEventListener('loadstart', function() {
        statusLog.innerHTML += `<p class="info">Iniciando upload dos arquivos...</p>`;
        statusLog.scrollTop = statusLog.scrollHeight;
    });
    
    xhr.send(formData);
});
</script>

</body>
</html>